/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *     Contains a number of data structures for working with scene information as well
 * as attributes to control display of scene objects.
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - Addeed XML comments
 *		12/20/2004 - Ben Watson - Added to VSS
 *
 *--*/

using System;
using System.Reflection;
using System.Drawing;

namespace BenWatson.BRayTracer
{
	/// <summary>
	/// Associates a display name with the scene object
	/// </summary>
	/// <example>A position vector would have Name = "Position" and Data = instance of Vector3f</example>
	/// <remarks>These are assigned to each TreeNode's Tag property so that the tree can display
	/// a descriptive name and the appropriate data for the scene object</remarks>
	public class SceneNodeInfo
	{
		/// <summary>
		/// Name of the object
		/// </summary>
		/// <example>"Position", "Radius", etc.</example>
		public String Name;
		/// <summary>
		/// The data object represented by this node
		/// </summary>
		public object Data;
	}

	/// <summary>
	/// Associates an editor form type with a display color
	/// </summary>
	public class EditorInfo 
	{
		/// <summary>
		/// Type of form to edit a certain scene object
		/// </summary>
		public Type EditorFormType;
		/// <summary>
		/// Color to display shapes of this type in the scene tree
		/// </summary>
		public Color NodeColor;
	}

	/// <summary>
	/// Specifies that the class member is directly editable
	/// </summary>
	public class EditableAttribute : System.Attribute
	{
		
	}

	/// <summary>
	/// Specifies that the class member is viewable, but not directly editable
	/// </summary>
	public class ViewableAttribute : System.Attribute
	{

	}


}
