/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Implements a light ray.     
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - Added to VSS
 *		12/26/2004 - Ben Watson - Added XML comments
 *
 *--*/

using System;


namespace BenWatson.BRayTracer.Raytracer
{
	/// <summary>
	/// Describes a light ray
	/// </summary>
	public struct Ray
	{
		/// <summary>
		/// Starting point of ray
		/// </summary>
		public Vector3f Start;
		/// <summary>
		/// Unit direction of ray
		/// </summary>
		public Vector3f Direction;

		/// <summary>
		/// Initializes a ray from the given position and direction and normalizes the direction
		/// </summary>
		/// <param name="StartPosition">The starting position of the ray</param>
		/// <param name="UnitDirection">The direction of the ray (will be normalized)</param>
		public Ray(Vector3f StartPosition, Vector3f UnitDirection)
		{
			Start = StartPosition;
			Direction = UnitDirection;
			if (UnitDirection.Magnitude!=1.0f)
				Direction.Normalize();
		}
	}
}
