/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Describes a camera for use in ray tracing.     
 *
 * Revision History:
 * 
 *
 *--*/

using System;


namespace BenWatson.BRayTracer.Raytracer
{
	/// <summary>
	/// Describes a camera for use in a ray tracing scene
	/// </summary>
	[Serializable]
	public class Camera
	{
		/// <summary>
		/// Position of camera
		/// </summary>
		protected Vector3f m_position;
		/// <summary>
		/// A point of unit length in front of camera
		/// </summary>
		protected Vector3f m_view;
		/// <summary>
		/// Point at which the camera is focused on
		/// </summary>
		protected Vector3f m_lookat;

		#region Properties
		/// <summary>
		/// Position of camera
		/// </summary>
		[Editable]
		public Vector3f Position 
		{
			get 
			{
				return m_position;
			}
			set 
			{
				m_position=value;
			}
		}

		/// <summary>
		/// Point at which camera is directly looking.
		/// </summary>
		[Editable]
		public Vector3f LookAt 
		{
			get 
			{
				return m_lookat;
			}
			set 
			{
				m_lookat=value;
			}
		}
		#endregion

		/// <summary>
		/// Initializes a new camera
		/// </summary>
		public Camera()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		/// <summary>
		/// Initializes a new camera
		/// </summary>
		/// <param name="Position">Position of camera</param>
		public Camera(Vector3f Position) 
		{
			this.Position=Position;
			this.LookAt = m_view = new Vector3f(0.0f,0.0f,0.0f);
			m_view = m_view - m_position;
			m_view.Normalize();
		}

		/// <summary>
		/// Initializes a new camera
		/// </summary>
		/// <param name="Position">Position of camera</param>
		/// <param name="LookAt">Point at which the camera is looking</param>
		public Camera(Vector3f Position, Vector3f LookAt) 
		{
			this.Position = Position;
			this.LookAt = m_view = LookAt - Position;
			m_view.Normalize();
		}

	}
}
