/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Contains the ProgramSettings structure that defines program-wide settings.
 *      
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - added XML comments
 *		12/20/2004 - Ben Watson - added to VSS
 *		12/26/2004 - Ben Watson - added render priorities
 *
 *--*/

using System;
using System.Drawing;
using System.Threading;

namespace BenWatson.BRayTracer
{

	/// <summary>
	/// Contains settings for the program (but not the rendering)
	/// </summary>
	public struct ProgramSettings
	{
		/// <summary>
		/// Scene file filter
		/// </summary>
		public String SceneFilenameFilter;
		/// <summary>
		/// Combined image filters for all supported export types
		/// </summary>
		public String ImageFilters;
		/// <summary>
		/// Default node color
		/// </summary>
		public Color DefaultNodeColor;
		/// <summary>
		/// Priority of rendering thread
		/// </summary>
		public ThreadPriority RenderPriority;
	}
}
