/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *     ImageFormatInfo associates a filename filter with the image type
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - added comments, added to source control
 *
 *--*/
using System;
using System.Drawing.Imaging;

namespace BenWatson.BRayTracer
{
	/// <summary>
	/// Describes an image format
	/// </summary>
	/// <remarks>Associates an image format with its filename filter</remarks>
	public struct ImageFormatInfo
	{
		/// <summary>
		/// A filename filter for this image type
		/// </summary>
		/// <remarks>Must be in the format "Descriptive Title |*.Extension"
		/// </remarks>
		/// <example>"Windows Bitmap (*.bmp)|*.bmp"</example>
		public String Filter;
		/// <summary>
		/// The image format, as defined by the .Net ImageFormat class
		/// </summary>
		public System.Drawing.Imaging.ImageFormat Format;

		/// <summary>
		/// Constructs a new image format
		/// </summary>
		/// <param name="Filter">The filename filter</param>
		/// <param name="Format">Format of the image</param>
		public ImageFormatInfo(String Filter, ImageFormat Format)
		{
			this.Filter = Filter;
			this.Format = Format;
		}
	}
}
