using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace BenWatson.BRayTracer.Forms
{
	/// <summary>
	/// Summary description for AboutForm.
	/// </summary>
	public class AboutForm : System.Windows.Forms.Form
	{
		#region UI Components
		private System.Windows.Forms.Button buttonClose;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		/// <summary>
		/// About label
		/// </summary>
		private System.Windows.Forms.LinkLabel labelAbout;


		private String aboutLabel = 
			"This program is for educational, personal, and non-commercial use only. "+
			"You may only use it to learn about ray tracing."+
			"\r\n\r\nIf you find this program useful, please donate at my website (http://www.benwatson.org)." +
			"\r\n\r\nIf you find a serious bug, or suggested improvement, please notify me at dev@benwatson.org.";

		/// <summary>
		/// Initializes a new about form.
		/// </summary>
		public AboutForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			labelAbout.Text = aboutLabel;
			labelAbout.Links[0].LinkData = "Visit me";
			labelAbout.Links.Add(185,24,"http://www.benwatson.org");
			labelAbout.Links.Add(288,17,"mailto:dev@benwatson.org");

			labelAbout.LinkClicked+=new LinkLabelLinkClickedEventHandler(labelAbout_LinkClicked);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.buttonClose = new System.Windows.Forms.Button();
			this.labelAbout = new System.Windows.Forms.LinkLabel();
			this.SuspendLayout();
			// 
			// buttonClose
			// 
			this.buttonClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonClose.Location = new System.Drawing.Point(228, 156);
			this.buttonClose.Name = "buttonClose";
			this.buttonClose.TabIndex = 0;
			this.buttonClose.Text = "&Close";
			// 
			// labelAbout
			// 
			this.labelAbout.Location = new System.Drawing.Point(8, 8);
			this.labelAbout.Name = "labelAbout";
			this.labelAbout.Size = new System.Drawing.Size(288, 136);
			this.labelAbout.TabIndex = 1;
			this.labelAbout.TabStop = true;
			this.labelAbout.Text = "linkLabel1";
			// 
			// AboutForm
			// 
			this.AcceptButton = this.buttonClose;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonClose;
			this.ClientSize = new System.Drawing.Size(304, 182);
			this.Controls.Add(this.labelAbout);
			this.Controls.Add(this.buttonClose);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "AboutForm";
			this.ShowInTaskbar = false;
			this.Text = "About Form";
			this.ResumeLayout(false);

		}
		#endregion

		private void labelAbout_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{

			
			this.labelAbout.Links[labelAbout.Links.IndexOf(e.Link)].Visited = true;

			// Display the appropriate link based on the value of the 
			// LinkData property of the Link object.
			string target = e.Link.LinkData as string;

			// If the value looks like a URL, navigate to it.
			// Otherwise, display it in a message box.
			if(null != target && (target.StartsWith("http") || target.StartsWith("mailto")))
			{
				System.Diagnostics.Process.Start(target);
			}
			else
			{    
				//MessageBox.Show("Item clicked: " + target);
			}

		}
	}
}
