/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/28/2004
 *
 * Abstract:
 *     Implements a shape property editor
 *
 * Revision History:
 *		12/29/2004 - Ben Watson - Added XML comments
 *
 *--*/

using System;
using System.Drawing;
using System.Reflection;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace BenWatson.BRayTracer.Editors
{
	
	/// <summary>
	/// Summary description for PropertyEditorForm.
	/// </summary>
	public class PropertyEditorForm : System.Windows.Forms.Form, IEditor
	{
		#region UI Components
		private System.Windows.Forms.PropertyGrid propertyGrid1;
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		/// <summary>
		/// Copy of scene object
		/// </summary>
		private object m_sceneObject = null;
		/// <summary>
		/// Reference to original scene object
		/// </summary>
		private object m_originalSceneObject = null;

		/// <summary>
		/// Initializes a new property editor form
		/// </summary>
		public PropertyEditorForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//

			
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.propertyGrid1 = new System.Windows.Forms.PropertyGrid();
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// propertyGrid1
			// 
			this.propertyGrid1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.propertyGrid1.CommandsVisibleIfAvailable = true;
			this.propertyGrid1.LargeButtons = false;
			this.propertyGrid1.LineColor = System.Drawing.SystemColors.ScrollBar;
			this.propertyGrid1.Location = new System.Drawing.Point(0, 0);
			this.propertyGrid1.Name = "propertyGrid1";
			this.propertyGrid1.Size = new System.Drawing.Size(334, 334);
			this.propertyGrid1.TabIndex = 0;
			this.propertyGrid1.Text = "propertyGrid1";
			this.propertyGrid1.ViewBackColor = System.Drawing.SystemColors.Window;
			this.propertyGrid1.ViewForeColor = System.Drawing.SystemColors.WindowText;
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(166, 342);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 1;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(246, 342);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 2;
			this.buttonCancel.Text = "&Cancel";
			// 
			// PropertyEditorForm
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(336, 368);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.Controls.Add(this.propertyGrid1);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "PropertyEditorForm";
			this.ShowInTaskbar = false;
			this.Text = "Properties";
			this.ResumeLayout(false);

		}
		#endregion

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			//TODO: copy all properties into original object
			CopyPropertiesToOriginal(this.m_sceneObject, m_originalSceneObject);

		}

		private void CopyPropertiesToOriginal(object source, object original) 
		{
			Type t = source.GetType();
			PropertyInfo[] props = t.GetProperties();
			foreach (PropertyInfo p in props) 
			{
				if (p.GetSetMethod()!=null) 
				{
					ParameterInfo[] pi = p.GetIndexParameters();
					if (pi.Length==0) 
					{
						p.SetValue(original,p.GetValue(source,null),null);
					} 
					else 
					{
						//TODO: must be a collection
					
					}
				}
			}

		}

		#region IEditor Members

		/// <summary>
		/// Gets or sets object editable by this editor
		/// </summary>
		public object EditableObject
		{
			get
			{
				return m_sceneObject;
			}
			set
			{
				m_originalSceneObject = value;
				m_sceneObject = ((ICloneable)value).Clone();
				this.propertyGrid1.SelectedObject = m_sceneObject;
			}
		}


		#endregion
	}
}
