/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		A custom, composite control for editing material properties.     
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - Added to VSS
 *		12/25/2004 - Ben Watson - Added XML comments
 *
 *--*/

using System;
using BenWatson.BRayTracer.Raytracer;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// A composite control for editing material properties
	/// </summary>
	public class MaterialEditorControl : System.Windows.Forms.UserControl
	{
		#region UI Components
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label labelReflectivity;
		private System.Windows.Forms.NumericUpDown numericUpDownReflectivity;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.NumericUpDown numericUpDownSpecularAmount;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.NumericUpDown numericUpDownSpecularCoefficient;
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.ColorDialog colorForm;
		private BenWatson.BRayTracer.Editors.ColorEditorControl colorEditorDiffuse;
		private BenWatson.BRayTracer.Editors.ColorEditorControl colorEditorSpecular;
		#endregion

		/// <summary>
		/// A copy of the material, for editing.
		/// </summary>
		private Material m_mat=null;

		/// <summary>
		/// Initializes a new material editor control.
		/// </summary>
		public MaterialEditorControl()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			this.colorEditorDiffuse.ColorChanged+=new EventHandler(colorEditorDiffuse_ColorChanged);
			this.colorEditorSpecular.ColorChanged+=new EventHandler(colorEditorSpecular_ColorChanged);
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Gets or sets the material to edit.
		/// </summary>
		public Material Material 
		{
			get 
			{
				return m_mat;
			}
			set 
			{
				if (value!=null) 
				{
					this.m_mat = (Material)value.Clone();
					this.colorEditorDiffuse.Color = m_mat.DiffuseColor;
					this.colorEditorSpecular.Color = m_mat.SpecularColor;

					UpdateView();
				}
			}
		}
		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.labelReflectivity = new System.Windows.Forms.Label();
			this.numericUpDownReflectivity = new System.Windows.Forms.NumericUpDown();
			this.label3 = new System.Windows.Forms.Label();
			this.numericUpDownSpecularAmount = new System.Windows.Forms.NumericUpDown();
			this.label4 = new System.Windows.Forms.Label();
			this.numericUpDownSpecularCoefficient = new System.Windows.Forms.NumericUpDown();
			this.colorForm = new System.Windows.Forms.ColorDialog();
			this.colorEditorDiffuse = new BenWatson.BRayTracer.Editors.ColorEditorControl();
			this.colorEditorSpecular = new BenWatson.BRayTracer.Editors.ColorEditorControl();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownReflectivity)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownSpecularAmount)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownSpecularCoefficient)).BeginInit();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(80, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Diffuse Color:";
			// 
			// label2
			// 
			this.label2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.label2.Location = new System.Drawing.Point(8, 142);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(88, 16);
			this.label2.TabIndex = 9;
			this.label2.Text = "Specular Color:";
			// 
			// labelReflectivity
			// 
			this.labelReflectivity.Anchor = System.Windows.Forms.AnchorStyles.Left;
			this.labelReflectivity.Location = new System.Drawing.Point(8, 48);
			this.labelReflectivity.Name = "labelReflectivity";
			this.labelReflectivity.Size = new System.Drawing.Size(64, 16);
			this.labelReflectivity.TabIndex = 3;
			this.labelReflectivity.Text = "Reflectivity:";
			// 
			// numericUpDownReflectivity
			// 
			this.numericUpDownReflectivity.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Left | System.Windows.Forms.AnchorStyles.Right)));
			this.numericUpDownReflectivity.DecimalPlaces = 2;
			this.numericUpDownReflectivity.Increment = new System.Decimal(new int[] {
																						10,
																						0,
																						0,
																						131072});
			this.numericUpDownReflectivity.Location = new System.Drawing.Point(120, 46);
			this.numericUpDownReflectivity.Maximum = new System.Decimal(new int[] {
																					  10,
																					  0,
																					  0,
																					  65536});
			this.numericUpDownReflectivity.Name = "numericUpDownReflectivity";
			this.numericUpDownReflectivity.Size = new System.Drawing.Size(48, 20);
			this.numericUpDownReflectivity.TabIndex = 4;
			this.numericUpDownReflectivity.ValueChanged += new System.EventHandler(this.OnReflectivityChanged);
			this.numericUpDownReflectivity.Leave += new System.EventHandler(this.OnReflectivityChanged);
			// 
			// label3
			// 
			this.label3.Anchor = System.Windows.Forms.AnchorStyles.Left;
			this.label3.Location = new System.Drawing.Point(8, 80);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(100, 16);
			this.label3.TabIndex = 5;
			this.label3.Text = "Specular Amount:";
			// 
			// numericUpDownSpecularAmount
			// 
			this.numericUpDownSpecularAmount.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Left | System.Windows.Forms.AnchorStyles.Right)));
			this.numericUpDownSpecularAmount.Location = new System.Drawing.Point(120, 78);
			this.numericUpDownSpecularAmount.Maximum = new System.Decimal(new int[] {
																						999999999,
																						0,
																						0,
																						0});
			this.numericUpDownSpecularAmount.Name = "numericUpDownSpecularAmount";
			this.numericUpDownSpecularAmount.Size = new System.Drawing.Size(96, 20);
			this.numericUpDownSpecularAmount.TabIndex = 6;
			this.numericUpDownSpecularAmount.ValueChanged += new System.EventHandler(this.OnSpecAmountChanged);
			this.numericUpDownSpecularAmount.Leave += new System.EventHandler(this.OnSpecAmountChanged);
			// 
			// label4
			// 
			this.label4.Anchor = System.Windows.Forms.AnchorStyles.Left;
			this.label4.Location = new System.Drawing.Point(8, 112);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(112, 14);
			this.label4.TabIndex = 7;
			this.label4.Text = "Specular Coefficient:";
			// 
			// numericUpDownSpecularCoefficient
			// 
			this.numericUpDownSpecularCoefficient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Left | System.Windows.Forms.AnchorStyles.Right)));
			this.numericUpDownSpecularCoefficient.Location = new System.Drawing.Point(120, 109);
			this.numericUpDownSpecularCoefficient.Maximum = new System.Decimal(new int[] {
																							 999999999,
																							 0,
																							 0,
																							 0});
			this.numericUpDownSpecularCoefficient.Name = "numericUpDownSpecularCoefficient";
			this.numericUpDownSpecularCoefficient.Size = new System.Drawing.Size(96, 20);
			this.numericUpDownSpecularCoefficient.TabIndex = 8;
			this.numericUpDownSpecularCoefficient.ValueChanged += new System.EventHandler(this.OnSpecCoefChanged);
			this.numericUpDownSpecularCoefficient.Leave += new System.EventHandler(this.OnSpecCoefChanged);
			// 
			// colorForm
			// 
			this.colorForm.AnyColor = true;
			this.colorForm.FullOpen = true;
			this.colorForm.SolidColorOnly = true;
			// 
			// colorEditorDiffuse
			// 
			this.colorEditorDiffuse.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.colorEditorDiffuse.Color = null;
			this.colorEditorDiffuse.Location = new System.Drawing.Point(80, 4);
			this.colorEditorDiffuse.Name = "colorEditorDiffuse";
			this.colorEditorDiffuse.Size = new System.Drawing.Size(200, 40);
			this.colorEditorDiffuse.TabIndex = 10;
			// 
			// colorEditorSpecular
			// 
			this.colorEditorSpecular.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.colorEditorSpecular.Color = null;
			this.colorEditorSpecular.Location = new System.Drawing.Point(88, 130);
			this.colorEditorSpecular.Name = "colorEditorSpecular";
			this.colorEditorSpecular.Size = new System.Drawing.Size(192, 40);
			this.colorEditorSpecular.TabIndex = 11;
			// 
			// MaterialEditorControl
			// 
			this.Controls.Add(this.colorEditorSpecular);
			this.Controls.Add(this.colorEditorDiffuse);
			this.Controls.Add(this.numericUpDownSpecularCoefficient);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.numericUpDownSpecularAmount);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.numericUpDownReflectivity);
			this.Controls.Add(this.labelReflectivity);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Name = "MaterialEditorControl";
			this.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.Size = new System.Drawing.Size(280, 176);
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownReflectivity)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownSpecularAmount)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownSpecularCoefficient)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		private void UpdateView() 
		{
			if (m_mat!=null) 
			{

				this.numericUpDownReflectivity.Value = (Decimal)m_mat.Reflectivity;
				this.numericUpDownSpecularAmount.Value = (Decimal)m_mat.SpecularAmount ;
				this.numericUpDownSpecularCoefficient.Value=(Decimal)m_mat.SpecularCoefficient ;
				
			}
		}
		
		private void OnReflectivityChanged(object sender, System.EventArgs e)
		{
			this.m_mat.Reflectivity=(float)this.numericUpDownReflectivity.Value;
		}

		private void OnSpecAmountChanged(object sender, System.EventArgs e)
		{
			this.m_mat.SpecularAmount=(float)this.numericUpDownSpecularAmount.Value;
		}

		private void OnSpecCoefChanged(object sender, System.EventArgs e)
		{
			this.m_mat.SpecularCoefficient=(float)this.numericUpDownSpecularCoefficient.Value;
		
		}

		private void colorEditorDiffuse_ColorChanged(object sender, EventArgs e)
		{
			this.m_mat.DiffuseColor = this.colorEditorDiffuse.Color;
		}

		private void colorEditorSpecular_ColorChanged(object sender, EventArgs e)
		{
			this.m_mat.SpecularColor = this.colorEditorSpecular.Color;
		}
	}
}
