/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Interface for primitive editors. The method ShowDialog is 
 * only to allow the underlying form to be displayed. It need never be implmented.
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - Added to VSS
 *		12/25/2004 - Ben Watson - Added XML comments
 *
 *--*/

using System;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// Interface for editor forms
	/// </summary>
	public interface IEditor
	{
		/// <summary>
		/// Gets and Sets the object editable by this form
		/// </summary>
		object EditableObject {get;set;}
		/// <summary>
		/// Shows the editor dialog.
		/// </summary>
		/// <remarks>Just calls Form.ShowDialog(). It should never need to be implemented.</remarks>
		/// <returns>The result of the dialog.</returns>
		System.Windows.Forms.DialogResult ShowDialog();
	}
}
