/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Implementation for a vector editor form.     
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - Added to VSS
 *		12/25/2004 - Ben Watson - Added XML comments
 *
 *--*/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using BenWatson.BRayTracer;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// Editor for vectors
	/// </summary>
	public class EditVectorForm : System.Windows.Forms.Form, IEditor
	{
		#region UI components
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.NumericUpDown numericUpDown_X;
		private System.Windows.Forms.NumericUpDown numericUpDown_Z;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.NumericUpDown numericUpDown_Y;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label labelLength;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label labelNormal;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		/// <summary>
		/// Copy of original vector
		/// </summary>
		private Vector3f m_vector;
		/// <summary>
		/// Reference to original vector
		/// </summary>
		private Vector3f m_originalVector;

		/// <summary>
		/// Initializes a new vector editor form.
		/// </summary>
		public EditVectorForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			this.numericUpDown_X.ValueChanged+=new EventHandler(OnValueChanged);
			this.numericUpDown_Y.ValueChanged+=new EventHandler(OnValueChanged);
			this.numericUpDown_Z.ValueChanged+=new EventHandler(OnValueChanged);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.numericUpDown_X = new System.Windows.Forms.NumericUpDown();
			this.numericUpDown_Z = new System.Windows.Forms.NumericUpDown();
			this.label2 = new System.Windows.Forms.Label();
			this.numericUpDown_Y = new System.Windows.Forms.NumericUpDown();
			this.label3 = new System.Windows.Forms.Label();
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.label4 = new System.Windows.Forms.Label();
			this.labelLength = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.labelNormal = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown_X)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown_Z)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown_Y)).BeginInit();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 18);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(16, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "X:";
			// 
			// numericUpDown_X
			// 
			this.numericUpDown_X.DecimalPlaces = 3;
			this.numericUpDown_X.Location = new System.Drawing.Point(40, 16);
			this.numericUpDown_X.Maximum = new System.Decimal(new int[] {
																			999999999,
																			0,
																			0,
																			0});
			this.numericUpDown_X.Minimum = new System.Decimal(new int[] {
																			999999999,
																			0,
																			0,
																			-2147483648});
			this.numericUpDown_X.Name = "numericUpDown_X";
			this.numericUpDown_X.Size = new System.Drawing.Size(96, 20);
			this.numericUpDown_X.TabIndex = 1;
			// 
			// numericUpDown_Z
			// 
			this.numericUpDown_Z.DecimalPlaces = 3;
			this.numericUpDown_Z.Location = new System.Drawing.Point(40, 80);
			this.numericUpDown_Z.Maximum = new System.Decimal(new int[] {
																			999999999,
																			0,
																			0,
																			0});
			this.numericUpDown_Z.Minimum = new System.Decimal(new int[] {
																			999999999,
																			0,
																			0,
																			-2147483648});
			this.numericUpDown_Z.Name = "numericUpDown_Z";
			this.numericUpDown_Z.Size = new System.Drawing.Size(96, 20);
			this.numericUpDown_Z.TabIndex = 5;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 82);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(16, 16);
			this.label2.TabIndex = 4;
			this.label2.Text = "Z:";
			// 
			// numericUpDown_Y
			// 
			this.numericUpDown_Y.DecimalPlaces = 3;
			this.numericUpDown_Y.Location = new System.Drawing.Point(40, 48);
			this.numericUpDown_Y.Maximum = new System.Decimal(new int[] {
																			999999999,
																			0,
																			0,
																			0});
			this.numericUpDown_Y.Minimum = new System.Decimal(new int[] {
																			999999999,
																			0,
																			0,
																			-2147483648});
			this.numericUpDown_Y.Name = "numericUpDown_Y";
			this.numericUpDown_Y.Size = new System.Drawing.Size(96, 20);
			this.numericUpDown_Y.TabIndex = 3;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 50);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(16, 16);
			this.label3.TabIndex = 2;
			this.label3.Text = "Y:";
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(160, 112);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 10;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(240, 112);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 11;
			this.buttonCancel.Text = "&Cancel";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(152, 32);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(48, 16);
			this.label4.TabIndex = 6;
			this.label4.Text = "Length:";
			// 
			// labelLength
			// 
			this.labelLength.Location = new System.Drawing.Point(208, 32);
			this.labelLength.Name = "labelLength";
			this.labelLength.Size = new System.Drawing.Size(100, 16);
			this.labelLength.TabIndex = 7;
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(152, 64);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(48, 16);
			this.label6.TabIndex = 8;
			this.label6.Text = "Normal: ";
			// 
			// labelNormal
			// 
			this.labelNormal.Location = new System.Drawing.Point(208, 64);
			this.labelNormal.Name = "labelNormal";
			this.labelNormal.Size = new System.Drawing.Size(100, 16);
			this.labelNormal.TabIndex = 9;
			// 
			// EditVectorForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(320, 142);
			this.Controls.Add(this.labelNormal);
			this.Controls.Add(this.label6);
			this.Controls.Add(this.labelLength);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.Controls.Add(this.numericUpDown_Y);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.numericUpDown_Z);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.numericUpDown_X);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditVectorForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Edit Vector";
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown_X)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown_Z)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown_Y)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Responds to changing vector values
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		/// <remarks>Updates the length and normal displays</remarks>
		private void OnValueChanged(object sender, System.EventArgs e)
		{
			if (sender == this.numericUpDown_X)
				m_vector.X = Convert.ToSingle(this.numericUpDown_X.Value);
			else if (sender==this.numericUpDown_Y)
				m_vector.Y = Convert.ToSingle(this.numericUpDown_Y.Value);
			else if (sender==this.numericUpDown_Z)
				m_vector.Z = Convert.ToSingle(this.numericUpDown_Z.Value);

			//update length and normal displays
			this.labelLength.Text = m_vector.Magnitude.ToString();
			this.labelNormal.Text = Vector3f.Normalize(m_vector).ToString();
		}

		#region IEditor Members

		/// <summary>
		/// Gets or sets the object editable by this editor
		/// </summary>
		public object EditableObject
		{
			get
			{
				return m_vector;
			}
			set
			{
				m_vector=(Vector3f)((Vector3f)value).Clone();
				m_originalVector = (Vector3f)value;
				UpdateView();
			}
		}

		
		private void UpdateView() 
		{
			this.numericUpDown_X.Value = (Decimal)m_vector.X;
			this.numericUpDown_Y.Value = (Decimal)m_vector.Y;
			this.numericUpDown_Z.Value = (Decimal)m_vector.Z;

			this.labelLength.Text = m_vector.Magnitude.ToString();
			this.labelNormal.Text = Vector3f.Normalize(m_vector).ToString();
		}

		#endregion

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			m_originalVector.X = Convert.ToSingle(this.numericUpDown_X.Value);
			m_originalVector.Y = Convert.ToSingle(this.numericUpDown_Y.Value);
			m_originalVector.Z = Convert.ToSingle(this.numericUpDown_Z.Value);;
		}
	}
}
