/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Implements editor for sphere primitives.     
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - Added to VSS
 *		12/25/2004 - Ben Watson - Added XML comments
 *
 *--*/

using System;
using BenWatson.BRayTracer.Primitives;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// Editor for a sphere primitive.
	/// </summary>
	public class EditSphereForm : System.Windows.Forms.Form, IEditor
	{
		#region UI Components
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label labelPosition;
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.GroupBox groupBox1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.NumericUpDown numericUpDownRadius;
		private System.Windows.Forms.Button buttonEditPosition;
		private BenWatson.BRayTracer.Editors.MaterialEditorControl materialEditorControl1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox textBoxShapeName;
		#endregion

		/// <summary>
		/// Copy of original sphere
		/// </summary>
		private Sphere m_sphere=null;
		/// <summary>
		/// Reference to original sphere
		/// </summary>
		private Sphere m_originalSphere=null;

		/// <summary>
		/// Initializes a new editor form.
		/// </summary>
		public EditSphereForm() 
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.labelPosition = new System.Windows.Forms.Label();
			this.numericUpDownRadius = new System.Windows.Forms.NumericUpDown();
			this.buttonEditPosition = new System.Windows.Forms.Button();
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.materialEditorControl1 = new BenWatson.BRayTracer.Editors.MaterialEditorControl();
			this.label3 = new System.Windows.Forms.Label();
			this.textBoxShapeName = new System.Windows.Forms.TextBox();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownRadius)).BeginInit();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 49);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(48, 16);
			this.label1.TabIndex = 2;
			this.label1.Text = "Position:";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 80);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(48, 17);
			this.label2.TabIndex = 5;
			this.label2.Text = "Radius:";
			// 
			// labelPosition
			// 
			this.labelPosition.Location = new System.Drawing.Point(64, 49);
			this.labelPosition.Name = "labelPosition";
			this.labelPosition.Size = new System.Drawing.Size(120, 16);
			this.labelPosition.TabIndex = 3;
			// 
			// numericUpDownRadius
			// 
			this.numericUpDownRadius.DecimalPlaces = 2;
			this.numericUpDownRadius.Location = new System.Drawing.Point(88, 78);
			this.numericUpDownRadius.Maximum = new System.Decimal(new int[] {
																				99999999,
																				0,
																				0,
																				0});
			this.numericUpDownRadius.Name = "numericUpDownRadius";
			this.numericUpDownRadius.Size = new System.Drawing.Size(104, 20);
			this.numericUpDownRadius.TabIndex = 6;
			// 
			// buttonEditPosition
			// 
			this.buttonEditPosition.Location = new System.Drawing.Point(200, 46);
			this.buttonEditPosition.Name = "buttonEditPosition";
			this.buttonEditPosition.TabIndex = 4;
			this.buttonEditPosition.Text = "Edit...";
			this.buttonEditPosition.Click += new System.EventHandler(this.buttonEditPosition_Click);
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(174, 310);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 8;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(254, 310);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 9;
			this.buttonCancel.Text = "Cancel";
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.materialEditorControl1);
			this.groupBox1.Location = new System.Drawing.Point(8, 112);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(328, 192);
			this.groupBox1.TabIndex = 7;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Material";
			// 
			// materialEditorControl1
			// 
			this.materialEditorControl1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.materialEditorControl1.Location = new System.Drawing.Point(3, 16);
			this.materialEditorControl1.Material = null;
			this.materialEditorControl1.Name = "materialEditorControl1";
			this.materialEditorControl1.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.materialEditorControl1.Size = new System.Drawing.Size(322, 173);
			this.materialEditorControl1.TabIndex = 0;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 18);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(40, 16);
			this.label3.TabIndex = 0;
			this.label3.Text = "Name:";
			// 
			// textBoxShapeName
			// 
			this.textBoxShapeName.Location = new System.Drawing.Point(64, 16);
			this.textBoxShapeName.Name = "textBoxShapeName";
			this.textBoxShapeName.Size = new System.Drawing.Size(120, 20);
			this.textBoxShapeName.TabIndex = 1;
			this.textBoxShapeName.Text = "";
			// 
			// EditSphereForm
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(338, 336);
			this.Controls.Add(this.textBoxShapeName);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.Controls.Add(this.buttonEditPosition);
			this.Controls.Add(this.numericUpDownRadius);
			this.Controls.Add(this.labelPosition);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditSphereForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Edit Sphere";
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownRadius)).EndInit();
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region IEditor Members

		/// <summary>
		/// Gets or sets the object editable by this form
		/// </summary>
		public object EditableObject
		{
			get
			{
				return m_sphere;
			}
			set
			{
				m_sphere = (value as Sphere).Clone() as Sphere;
				m_originalSphere = (Sphere)value;
				
				UpdateView();
			
			}
		}

		#endregion

		/// <summary>
		/// Updates he controls with the sphere data
		/// </summary>
		private void UpdateView() 
		{
			if (m_sphere!=null) 
			{
				this.labelPosition.Text = m_sphere.Position.ToString();
				this.numericUpDownRadius.Value = (Decimal)m_sphere.Radius;
				this.materialEditorControl1.Material = m_sphere.Material;
				this.textBoxShapeName.Text = m_sphere.Name;

			}
		}

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			//copy over values
			if (m_sphere!=null) 
			{
				m_originalSphere.Position = m_sphere.Position;
				m_originalSphere.Radius = (float)this.numericUpDownRadius.Value;
				m_originalSphere.Material = this.materialEditorControl1.Material;
				m_originalSphere.Name = this.textBoxShapeName.Text;
			}

		}

		private void buttonEditPosition_Click(object sender, System.EventArgs e)
		{
			EditVectorForm f = new EditVectorForm();
			f.EditableObject = this.m_sphere.Position;
			if (f.ShowDialog()==DialogResult.OK) 
			{
				this.labelPosition.Text = m_sphere.Position.ToString();
			}
		}
	}
}
