/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Implementation of polygon mesh editor form.     
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - Added to VSS
 *		12/25/2004 - Ben Watson - Added XML comments
 *
 *--*/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using BenWatson.BRayTracer.Primitives;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// Implementation of an editor for polygon meshes
	/// </summary>
	public class EditPolygonMeshForm : System.Windows.Forms.Form, IEditor
	{
		#region UI Components
		private System.Windows.Forms.Button buttonLoadFromFile;
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.GroupBox groupBox1;
		private BenWatson.BRayTracer.Editors.MaterialEditorControl materialEditorControl1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox textBoxName;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label labelOriginalFilename;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label labelNumVertices;
		private System.Windows.Forms.Label labelNumPolygons;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Button buttonEdit;
		private System.Windows.Forms.Label labelPosition;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		/// <summary>
		/// Reference to original mesh
		/// </summary>
		private PolygonMesh m_originalMesh = null;
		/// <summary>
		/// Position of mesh
		/// </summary>
		private Vector3f m_position = null;

		/// <summary>
		/// Initializes a new editor form for polygon meshes.
		/// </summary>
		public EditPolygonMeshForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.buttonLoadFromFile = new System.Windows.Forms.Button();
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.materialEditorControl1 = new BenWatson.BRayTracer.Editors.MaterialEditorControl();
			this.label1 = new System.Windows.Forms.Label();
			this.textBoxName = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.labelOriginalFilename = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.labelNumVertices = new System.Windows.Forms.Label();
			this.labelNumPolygons = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.labelPosition = new System.Windows.Forms.Label();
			this.buttonEdit = new System.Windows.Forms.Button();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// buttonLoadFromFile
			// 
			this.buttonLoadFromFile.Location = new System.Drawing.Point(208, 8);
			this.buttonLoadFromFile.Name = "buttonLoadFromFile";
			this.buttonLoadFromFile.Size = new System.Drawing.Size(104, 23);
			this.buttonLoadFromFile.TabIndex = 4;
			this.buttonLoadFromFile.Text = "Load From File...";
			this.buttonLoadFromFile.Click += new System.EventHandler(this.buttonLoadFromFile_Click);
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(166, 366);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 10;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(246, 366);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 11;
			this.buttonCancel.Text = "&Cancel";
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.materialEditorControl1);
			this.groupBox1.Location = new System.Drawing.Point(8, 168);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(312, 192);
			this.groupBox1.TabIndex = 9;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Material";
			// 
			// materialEditorControl1
			// 
			this.materialEditorControl1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.materialEditorControl1.Location = new System.Drawing.Point(3, 16);
			this.materialEditorControl1.Material = null;
			this.materialEditorControl1.Name = "materialEditorControl1";
			this.materialEditorControl1.Size = new System.Drawing.Size(306, 173);
			this.materialEditorControl1.TabIndex = 0;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(40, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Name:";
			// 
			// textBoxName
			// 
			this.textBoxName.Location = new System.Drawing.Point(56, 6);
			this.textBoxName.Name = "textBoxName";
			this.textBoxName.Size = new System.Drawing.Size(128, 20);
			this.textBoxName.TabIndex = 1;
			this.textBoxName.Text = "";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 40);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(96, 16);
			this.label2.TabIndex = 2;
			this.label2.Text = "Original Filename:";
			// 
			// labelOriginalFilename
			// 
			this.labelOriginalFilename.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.labelOriginalFilename.Location = new System.Drawing.Point(104, 40);
			this.labelOriginalFilename.Name = "labelOriginalFilename";
			this.labelOriginalFilename.Size = new System.Drawing.Size(216, 32);
			this.labelOriginalFilename.TabIndex = 3;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 112);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(104, 16);
			this.label3.TabIndex = 5;
			this.label3.Text = "Number of Vertices:";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(16, 136);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(112, 16);
			this.label4.TabIndex = 7;
			this.label4.Text = "Number of Polygons:";
			// 
			// labelNumVertices
			// 
			this.labelNumVertices.Location = new System.Drawing.Point(144, 112);
			this.labelNumVertices.Name = "labelNumVertices";
			this.labelNumVertices.Size = new System.Drawing.Size(100, 16);
			this.labelNumVertices.TabIndex = 6;
			// 
			// labelNumPolygons
			// 
			this.labelNumPolygons.Location = new System.Drawing.Point(144, 136);
			this.labelNumPolygons.Name = "labelNumPolygons";
			this.labelNumPolygons.Size = new System.Drawing.Size(100, 16);
			this.labelNumPolygons.TabIndex = 8;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(16, 80);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(48, 16);
			this.label5.TabIndex = 12;
			this.label5.Text = "Position:";
			// 
			// labelPosition
			// 
			this.labelPosition.Location = new System.Drawing.Point(80, 80);
			this.labelPosition.Name = "labelPosition";
			this.labelPosition.Size = new System.Drawing.Size(176, 16);
			this.labelPosition.TabIndex = 13;
			// 
			// buttonEdit
			// 
			this.buttonEdit.Location = new System.Drawing.Point(264, 77);
			this.buttonEdit.Name = "buttonEdit";
			this.buttonEdit.Size = new System.Drawing.Size(48, 23);
			this.buttonEdit.TabIndex = 14;
			this.buttonEdit.Text = "Edit...";
			this.buttonEdit.Click += new System.EventHandler(this.buttonEdit_Click);
			// 
			// EditPolygonMeshForm
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(330, 392);
			this.Controls.Add(this.buttonEdit);
			this.Controls.Add(this.labelPosition);
			this.Controls.Add(this.label5);
			this.Controls.Add(this.labelNumPolygons);
			this.Controls.Add(this.labelNumVertices);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.labelOriginalFilename);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.textBoxName);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.Controls.Add(this.buttonLoadFromFile);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditPolygonMeshForm";
			this.ShowInTaskbar = false;
			this.Text = "Edit Polygon Mesh";
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region IEditor Members

		/// <summary>
		/// Gets or sets the object editable by this form
		/// </summary>
		public object EditableObject
		{
			get
			{
				return m_originalMesh;
			}
			set
			{
				m_originalMesh = value as PolygonMesh;
				if (m_originalMesh!=null) 
				{
					m_position = (Vector3f)m_originalMesh.Position.Clone();
					this.materialEditorControl1.Material = m_originalMesh.Material;

					UpdateView();
				}
			}
		}


		#endregion

		/// <summary>
		/// Updates controls with mesh data
		/// </summary>
		private void UpdateView() 
		{
			if (m_originalMesh!=null) {
				this.labelNumPolygons.Text = m_originalMesh.NumPolygons.ToString();
				this.labelNumVertices.Text = m_originalMesh.NumVertices.ToString();
				this.labelOriginalFilename.Text = m_originalMesh.OriginalFilename;
				this.labelPosition.Text = m_position.ToString();
			}
		}

		private void buttonEdit_Click(object sender, System.EventArgs e)
		{
			EditVectorForm f = new EditVectorForm();
			f.EditableObject = this.m_position;
			if (f.ShowDialog()==DialogResult.OK) 
			{
				UpdateView();
			}
		}

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			m_originalMesh.Position = this.m_position;
			m_originalMesh.Material = this.materialEditorControl1.Material;
			m_originalMesh.Name = this.textBoxName.Text;

		}

		private void buttonLoadFromFile_Click(object sender, System.EventArgs e)
		{
			if (MessageBox.Show("If you load a new mesh, you will not be able to cancel your edit of this mesh.\n\nDo you wn=ant to proceed?","Warning",MessageBoxButtons.YesNo,MessageBoxIcon.Warning)==DialogResult.Yes)
			{
				OpenFileDialog ofd = new OpenFileDialog();
				ofd.Filter = "Mesh files (.d)|*.d";
				if (ofd.ShowDialog()==DialogResult.OK) 
				{

					bool result = m_originalMesh.LoadFromFile(ofd.FileName);
					if (result) 
					{
						this.buttonCancel.Enabled=false;
						this.ControlBox=false;
						UpdateView();
					}

				}


			}

		}
	}
}
