/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *    Implementation class for a polygon editor form.
 *
 * Revision History:
 *		12/20/2004 - Added to VSS
 *		12/25/2004 - Added XML comments
 *	
 *
 *--*/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using BenWatson.BRayTracer.Primitives;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// Implementation class for a polygon editor form.
	/// </summary>
	public class EditPolygonForm : System.Windows.Forms.Form, IEditor
	{
		#region UI Elements
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox textBoxName;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.ListBox listBoxVertices;
		private System.Windows.Forms.Label label2;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button buttonAddVertex;
		private System.Windows.Forms.Button buttonDeleteVertex;
		private BenWatson.BRayTracer.Editors.MaterialEditorControl materialEditorControl1;

		private System.Windows.Forms.CheckBox checkBoxPlanar;
		
		#endregion

		/// <summary>
		/// Reference to original polygon
		/// </summary>
		private Polygon m_originalPolygon = null;

		/// <summary>
		/// List of vertices
		/// </summary>
		private System.Collections.ArrayList vertexList = new ArrayList();

		/// <summary>
		/// Initializes a new polygon editor form
		/// </summary>
		public EditPolygonForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.textBoxName = new System.Windows.Forms.TextBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.listBoxVertices = new System.Windows.Forms.ListBox();
			this.label2 = new System.Windows.Forms.Label();
			this.checkBoxPlanar = new System.Windows.Forms.CheckBox();
			this.buttonAddVertex = new System.Windows.Forms.Button();
			this.buttonDeleteVertex = new System.Windows.Forms.Button();
			this.materialEditorControl1 = new BenWatson.BRayTracer.Editors.MaterialEditorControl();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(48, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Name:";
			// 
			// textBoxName
			// 
			this.textBoxName.Location = new System.Drawing.Point(72, 14);
			this.textBoxName.Name = "textBoxName";
			this.textBoxName.Size = new System.Drawing.Size(128, 20);
			this.textBoxName.TabIndex = 1;
			this.textBoxName.Text = "";
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.materialEditorControl1);
			this.groupBox1.Location = new System.Drawing.Point(8, 168);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(318, 192);
			this.groupBox1.TabIndex = 2;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Material";
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(166, 366);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 3;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(246, 366);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 4;
			this.buttonCancel.Text = "&Cancel";
			// 
			// listBoxVertices
			// 
			this.listBoxVertices.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.listBoxVertices.Location = new System.Drawing.Point(16, 72);
			this.listBoxVertices.Name = "listBoxVertices";
			this.listBoxVertices.Size = new System.Drawing.Size(224, 82);
			this.listBoxVertices.TabIndex = 5;
			this.listBoxVertices.DoubleClick += new System.EventHandler(this.OnListItemDblClick);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 48);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(56, 16);
			this.label2.TabIndex = 6;
			this.label2.Text = "Vertices:";
			// 
			// checkBoxPlanar
			// 
			this.checkBoxPlanar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.checkBoxPlanar.Enabled = false;
			this.checkBoxPlanar.Location = new System.Drawing.Point(256, 48);
			this.checkBoxPlanar.Name = "checkBoxPlanar";
			this.checkBoxPlanar.Size = new System.Drawing.Size(64, 16);
			this.checkBoxPlanar.TabIndex = 7;
			this.checkBoxPlanar.Text = "Planar?";
			// 
			// buttonAddVertex
			// 
			this.buttonAddVertex.Location = new System.Drawing.Point(248, 72);
			this.buttonAddVertex.Name = "buttonAddVertex";
			this.buttonAddVertex.TabIndex = 8;
			this.buttonAddVertex.Text = "Add...";
			this.buttonAddVertex.Click += new System.EventHandler(this.buttonAddVertex_Click);
			// 
			// buttonDeleteVertex
			// 
			this.buttonDeleteVertex.Location = new System.Drawing.Point(248, 112);
			this.buttonDeleteVertex.Name = "buttonDeleteVertex";
			this.buttonDeleteVertex.TabIndex = 9;
			this.buttonDeleteVertex.Text = "Delete";
			this.buttonDeleteVertex.Click += new System.EventHandler(this.buttonDeleteVertex_Click);
			// 
			// materialEditorControl1
			// 
			this.materialEditorControl1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.materialEditorControl1.Location = new System.Drawing.Point(3, 16);
			this.materialEditorControl1.Material = null;
			this.materialEditorControl1.Name = "materialEditorControl1";
			this.materialEditorControl1.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.materialEditorControl1.Size = new System.Drawing.Size(312, 173);
			this.materialEditorControl1.TabIndex = 0;
			// 
			// EditPolygonForm
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(330, 392);
			this.Controls.Add(this.buttonDeleteVertex);
			this.Controls.Add(this.buttonAddVertex);
			this.Controls.Add(this.checkBoxPlanar);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.listBoxVertices);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.textBoxName);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditPolygonForm";
			this.ShowInTaskbar = false;
			this.Text = "Edit Polygon";
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			m_originalPolygon.Name = this.textBoxName.Text;
			m_originalPolygon.Material = this.materialEditorControl1.Material;
			
		}

		private void buttonAddVertex_Click(object sender, System.EventArgs e)
		{
		
		}

		private void buttonDeleteVertex_Click(object sender, System.EventArgs e)
		{
		
		}

		private void OnListItemDblClick(object sender, System.EventArgs e)
		{
		
		}
		#region IEditor Members

		/// <summary>
		/// Gets or sets the object editable by this form
		/// </summary>
		public object EditableObject
		{
			get
			{
				return m_originalPolygon;
				
			}
			set
			{
				m_originalPolygon = (Polygon)value;
				this.materialEditorControl1.Material = m_originalPolygon.Material;
				if (m_originalPolygon.Vertices!=null) 
				{
					foreach (Vector3f v in m_originalPolygon.Vertices) 
					{
						vertexList.Add(v.Clone());
					
					}
					this.listBoxVertices.Items.AddRange(m_originalPolygon.Vertices.ToArray());
				}

			}
		}


		#endregion
	}
}
