/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Implementation for a plane editor form.    
 *
 * Revision History:
 *		12/20/2004 - Added to VSS
 *		12/25/2004 - Added XML comments
 *
 *--*/

using System;
using BenWatson.BRayTracer.Primitives;
using BenWatson.BRayTracer.Raytracer;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// Implementation class for a plane editor
	/// </summary>
	public class EditPlaneForm : System.Windows.Forms.Form, IEditor
	{
		#region UI elements
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label labelPosition;
		private System.Windows.Forms.Button buttonEditPosition;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label labelNormal;
		private System.Windows.Forms.Button buttonEditNormal;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox textBoxShapeName;
		private BenWatson.BRayTracer.Editors.MaterialEditorControl materialEditorControl1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion
		/// <summary>
		/// Temporary plane for editing 
		/// </summary>
		private Plane m_plane;
		/// <summary>
		/// Reference to original plane
		/// </summary>
		private Plane m_originalPlane;

		/// <summary>
		/// Initializes a new plane editor form
		/// </summary>
		public EditPlaneForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.labelPosition = new System.Windows.Forms.Label();
			this.buttonEditPosition = new System.Windows.Forms.Button();
			this.label2 = new System.Windows.Forms.Label();
			this.labelNormal = new System.Windows.Forms.Label();
			this.buttonEditNormal = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.materialEditorControl1 = new BenWatson.BRayTracer.Editors.MaterialEditorControl();
			this.label3 = new System.Windows.Forms.Label();
			this.textBoxShapeName = new System.Windows.Forms.TextBox();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(166, 318);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 9;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(246, 318);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 10;
			this.buttonCancel.Text = "&Cancel";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 48);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(48, 16);
			this.label1.TabIndex = 2;
			this.label1.Text = "Position:";
			// 
			// labelPosition
			// 
			this.labelPosition.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.labelPosition.Location = new System.Drawing.Point(72, 48);
			this.labelPosition.Name = "labelPosition";
			this.labelPosition.Size = new System.Drawing.Size(170, 16);
			this.labelPosition.TabIndex = 3;
			// 
			// buttonEditPosition
			// 
			this.buttonEditPosition.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonEditPosition.Location = new System.Drawing.Point(258, 48);
			this.buttonEditPosition.Name = "buttonEditPosition";
			this.buttonEditPosition.Size = new System.Drawing.Size(56, 23);
			this.buttonEditPosition.TabIndex = 4;
			this.buttonEditPosition.Text = "Edit...";
			this.buttonEditPosition.Click += new System.EventHandler(this.buttonEditPosition_Click);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 80);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(48, 16);
			this.label2.TabIndex = 5;
			this.label2.Text = "Normal:";
			// 
			// labelNormal
			// 
			this.labelNormal.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.labelNormal.Location = new System.Drawing.Point(72, 80);
			this.labelNormal.Name = "labelNormal";
			this.labelNormal.Size = new System.Drawing.Size(170, 16);
			this.labelNormal.TabIndex = 6;
			// 
			// buttonEditNormal
			// 
			this.buttonEditNormal.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonEditNormal.Location = new System.Drawing.Point(258, 80);
			this.buttonEditNormal.Name = "buttonEditNormal";
			this.buttonEditNormal.Size = new System.Drawing.Size(56, 23);
			this.buttonEditNormal.TabIndex = 7;
			this.buttonEditNormal.Text = "Edit...";
			this.buttonEditNormal.Click += new System.EventHandler(this.buttonEditNormal_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.materialEditorControl1);
			this.groupBox1.Location = new System.Drawing.Point(0, 112);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(320, 192);
			this.groupBox1.TabIndex = 8;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Material";
			// 
			// materialEditorControl1
			// 
			this.materialEditorControl1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.materialEditorControl1.Location = new System.Drawing.Point(3, 16);
			this.materialEditorControl1.Material = null;
			this.materialEditorControl1.Name = "materialEditorControl1";
			this.materialEditorControl1.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.materialEditorControl1.Size = new System.Drawing.Size(314, 173);
			this.materialEditorControl1.TabIndex = 0;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 16);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(40, 16);
			this.label3.TabIndex = 0;
			this.label3.Text = "Name:";
			// 
			// textBoxShapeName
			// 
			this.textBoxShapeName.Location = new System.Drawing.Point(72, 16);
			this.textBoxShapeName.Name = "textBoxShapeName";
			this.textBoxShapeName.Size = new System.Drawing.Size(162, 20);
			this.textBoxShapeName.TabIndex = 1;
			this.textBoxShapeName.Text = "";
			// 
			// EditPlaneForm
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(322, 344);
			this.Controls.Add(this.textBoxShapeName);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.buttonEditNormal);
			this.Controls.Add(this.labelNormal);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.buttonEditPosition);
			this.Controls.Add(this.labelPosition);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditPlaneForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Edit Plane";
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void buttonEditPosition_Click(object sender, System.EventArgs e)
		{
			EditVectorForm f=new EditVectorForm();
			f.EditableObject = this.m_plane.Origin;
			if (f.ShowDialog()==DialogResult.OK) 
			{
				this.labelPosition.Text = m_plane.Origin.ToString();
				m_plane.Origin = m_plane.Origin;
			}
		
		}

		private void buttonEditNormal_Click(object sender, System.EventArgs e)
		{
			EditVectorForm f=new EditVectorForm();
			f.EditableObject = this.m_plane.Normal;
			if (f.ShowDialog()==DialogResult.OK) 
			{
				this.labelNormal.Text = m_plane.Normal.ToString();
				m_plane.Normal = m_plane.Normal;
			}
		}

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			m_originalPlane.Material = this.materialEditorControl1.Material;
			m_originalPlane.Name = this.textBoxShapeName.Text;
			m_originalPlane.Origin = this.m_plane.Origin;
			m_originalPlane.Normal = this.m_plane.Normal;
		}

		#region IEditor Members

		/// <summary>
		/// Gets or sets the object editable this form
		/// </summary>
		public object EditableObject
		{
			get
			{
				return m_plane;
			}
			set
			{
				m_originalPlane = (Plane)value;
				m_plane = (Plane)(value as Plane).Clone();
				this.materialEditorControl1.Material = m_plane.Material;
				UpdateView();
			}
		}

		#endregion

		/// <summary>
		/// Updates form controls with data
		/// </summary>
		private void UpdateView() 
		{
			this.textBoxShapeName.Text = m_plane.Name;
			this.labelNormal.Text = m_plane.Normal.ToString();
			this.labelPosition.Text = m_plane.Origin.ToString();
		}
	}
}
