/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *    Implementation for the material editor. 
 *
 * Revision History:
 *		12/20/2004 - Added to VSS
 *		12/25/2004 - Added XML comments
 * 
 *
 *--*/
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using BenWatson.BRayTracer.Raytracer;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// Implementation for Material editor form.
	/// </summary>
	public class EditMaterialForm : System.Windows.Forms.Form, IEditor
	{
		#region UI Elements
		private BenWatson.BRayTracer.Editors.MaterialEditorControl materialEditorControl1;
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		//private Material m_mat=null;
		/// <summary>
		/// References to original material.
		/// </summary>
		private Material m_originalMat=null;

		/// <summary>
		/// Initializes a new material editor form
		/// </summary>
		public EditMaterialForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.materialEditorControl1 = new BenWatson.BRayTracer.Editors.MaterialEditorControl();
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// materialEditorControl1
			// 
			this.materialEditorControl1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.materialEditorControl1.Location = new System.Drawing.Point(0, 0);
			this.materialEditorControl1.Material = null;
			this.materialEditorControl1.Name = "materialEditorControl1";
			this.materialEditorControl1.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.materialEditorControl1.Size = new System.Drawing.Size(314, 176);
			this.materialEditorControl1.TabIndex = 0;
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(154, 176);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 1;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(234, 176);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 2;
			this.buttonCancel.Text = "&Cancel";
			// 
			// EditMaterialForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(314, 200);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.Controls.Add(this.materialEditorControl1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditMaterialForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Edit Material";
			this.ResumeLayout(false);

		}
		#endregion

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			Material mat = this.materialEditorControl1.Material;

			m_originalMat.DiffuseColor = mat.DiffuseColor;
			m_originalMat.Reflectivity = mat.Reflectivity;
			m_originalMat.SpecularAmount = mat.SpecularAmount;
			m_originalMat.SpecularCoefficient = mat.SpecularCoefficient;
			m_originalMat.SpecularColor = mat.SpecularColor;

		}
		#region IEditor Members

		/// <summary>
		/// Gets or sets the object editable by this form
		/// </summary>
		public object EditableObject
		{
			get
			{
				return this.materialEditorControl1.Material;
			}
			set
			{
				m_originalMat=(Material)value;
				this.materialEditorControl1.Material=(Material)value;
			}
		}

		#endregion
	}
}
