/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Implmentation for a light editor form. 
 *
 * Revision History:
 *		12/20/2004 - Added to VS
 *		12/25/2004 - Added XML comments
 *
 *--*/
using System;
using BenWatson.BRayTracer.Raytracer;
using BenWatson.BRayTracer;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// Form for editing a light object.
	/// </summary>
	public class EditLightForm : System.Windows.Forms.Form, IEditor
	{
		#region UI Elements
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label labelPosition;
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.Button buttonEditPosition;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox textBoxLightName;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private BenWatson.BRayTracer.Editors.ColorEditorControl colorEditorControl1;
		private System.Windows.Forms.Label label2;
		
		private System.Windows.Forms.ColorDialog colorForm;
		
		#endregion

		/// <summary>
		/// References to original light
		/// </summary>
		private Light m_originalLight=null;
		/// <summary>
		/// Copy of the light's position
		/// </summary>
		private Vector3f m_position=null;
		

		/// <summary>
		/// Initializes a new light form
		/// </summary>
		public EditLightForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.labelPosition = new System.Windows.Forms.Label();
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.buttonEditPosition = new System.Windows.Forms.Button();
			this.label3 = new System.Windows.Forms.Label();
			this.textBoxLightName = new System.Windows.Forms.TextBox();
			this.colorForm = new System.Windows.Forms.ColorDialog();
			this.colorEditorControl1 = new BenWatson.BRayTracer.Editors.ColorEditorControl();
			this.label2 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 52);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(48, 16);
			this.label1.TabIndex = 2;
			this.label1.Text = "Position:";
			// 
			// labelPosition
			// 
			this.labelPosition.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.labelPosition.Location = new System.Drawing.Point(56, 52);
			this.labelPosition.Name = "labelPosition";
			this.labelPosition.Size = new System.Drawing.Size(168, 16);
			this.labelPosition.TabIndex = 3;
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(128, 134);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 8;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(208, 134);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 9;
			this.buttonCancel.Text = "&Cancel";
			// 
			// buttonEditPosition
			// 
			this.buttonEditPosition.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonEditPosition.Location = new System.Drawing.Point(232, 49);
			this.buttonEditPosition.Name = "buttonEditPosition";
			this.buttonEditPosition.Size = new System.Drawing.Size(48, 23);
			this.buttonEditPosition.TabIndex = 4;
			this.buttonEditPosition.Text = "Edit...";
			this.buttonEditPosition.Click += new System.EventHandler(this.buttonEditPosition_Click);
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 16);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(40, 16);
			this.label3.TabIndex = 0;
			this.label3.Text = "Name:";
			// 
			// textBoxLightName
			// 
			this.textBoxLightName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.textBoxLightName.Location = new System.Drawing.Point(56, 16);
			this.textBoxLightName.Name = "textBoxLightName";
			this.textBoxLightName.Size = new System.Drawing.Size(144, 20);
			this.textBoxLightName.TabIndex = 1;
			this.textBoxLightName.Text = "";
			// 
			// colorForm
			// 
			this.colorForm.AnyColor = true;
			this.colorForm.FullOpen = true;
			// 
			// colorEditorControl1
			// 
			this.colorEditorControl1.Color = null;
			this.colorEditorControl1.Location = new System.Drawing.Point(56, 80);
			this.colorEditorControl1.Name = "colorEditorControl1";
			this.colorEditorControl1.Size = new System.Drawing.Size(232, 40);
			this.colorEditorControl1.TabIndex = 10;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 96);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(32, 16);
			this.label2.TabIndex = 11;
			this.label2.Text = "Color:";
			// 
			// EditLightForm
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(292, 160);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.colorEditorControl1);
			this.Controls.Add(this.textBoxLightName);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.buttonEditPosition);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.Controls.Add(this.labelPosition);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditLightForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Edit Light";
			this.ResumeLayout(false);

		}
		#endregion

		#region IEditor Members

		/// <summary>
		/// Gets or sets the object editable by this form.
		/// </summary>
		public object EditableObject
		{
			get
			{
				return m_originalLight;
			}
			set
			{
				m_originalLight = (Light)value;
				m_position = (Vector3f)m_originalLight.Position.Clone();
				this.colorEditorControl1.Color = m_originalLight.Color;

				this.labelPosition.Text = m_position.ToString();
				
			}
		}

		#endregion

		
		private void buttonEditPosition_Click(object sender, System.EventArgs e)
		{
			EditVectorForm f=new EditVectorForm();
			f.EditableObject = m_position;
			if (f.ShowDialog()==DialogResult.OK) 
			{
				m_position = (Vector3f)f.EditableObject;
				this.labelPosition.Text = m_position.ToString();
				
			}
		}

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			m_originalLight.Color = this.colorEditorControl1.Color;
			m_originalLight.Name = this.textBoxLightName.Text;
			m_originalLight.Position = this.m_position;
		}
	}
}
