/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Implementation of cylinder editor     
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - Added to VSS
 *		12/25/2004 - Ben Watson - Added XML comments
 *
 *--*/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using BenWatson.BRayTracer.Primitives;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// A form for editing cylinders.
	/// </summary>
	public class EditCylinderForm : System.Windows.Forms.Form, IEditor
	{
		#region UI Elements
		private BenWatson.BRayTracer.Editors.MaterialEditorControl materialEditorControl1;
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox textBoxName;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label labelPosition;
		private System.Windows.Forms.Button buttonEditPosition;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label labelAxis;
		private System.Windows.Forms.Button buttonEditAxis;
		private System.Windows.Forms.CheckBox checkBoxCapped;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.NumericUpDown numericUpDownRadius;
		private System.Windows.Forms.NumericUpDown numericUpDownHeight;

		#endregion

		/// <summary>
		/// Reference to original cylinder
		/// </summary>
		private Cylinder m_originalCylinder = null;
		/// <summary>
		/// Copy of the position
		/// </summary>
		private Vector3f m_position=null, m_axis=null;
		
		/// <summary>
		/// Constructs a new form for editing cylinders
		/// </summary>
		public EditCylinderForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.materialEditorControl1 = new BenWatson.BRayTracer.Editors.MaterialEditorControl();
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.textBoxName = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.labelPosition = new System.Windows.Forms.Label();
			this.buttonEditPosition = new System.Windows.Forms.Button();
			this.label3 = new System.Windows.Forms.Label();
			this.labelAxis = new System.Windows.Forms.Label();
			this.buttonEditAxis = new System.Windows.Forms.Button();
			this.checkBoxCapped = new System.Windows.Forms.CheckBox();
			this.label4 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.numericUpDownRadius = new System.Windows.Forms.NumericUpDown();
			this.numericUpDownHeight = new System.Windows.Forms.NumericUpDown();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownRadius)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownHeight)).BeginInit();
			this.SuspendLayout();
			// 
			// materialEditorControl1
			// 
			this.materialEditorControl1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.materialEditorControl1.Location = new System.Drawing.Point(0, 146);
			this.materialEditorControl1.Material = null;
			this.materialEditorControl1.Name = "materialEditorControl1";
			this.materialEditorControl1.Size = new System.Drawing.Size(362, 176);
			this.materialEditorControl1.TabIndex = 0;
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(194, 330);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 1;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(282, 330);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 2;
			this.buttonCancel.Text = "&Cancel";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(40, 16);
			this.label1.TabIndex = 3;
			this.label1.Text = "Name:";
			// 
			// textBoxName
			// 
			this.textBoxName.Location = new System.Drawing.Point(64, 16);
			this.textBoxName.Name = "textBoxName";
			this.textBoxName.Size = new System.Drawing.Size(144, 20);
			this.textBoxName.TabIndex = 4;
			this.textBoxName.Text = "";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 50);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(48, 16);
			this.label2.TabIndex = 5;
			this.label2.Text = "Position:";
			// 
			// labelPosition
			// 
			this.labelPosition.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.labelPosition.Location = new System.Drawing.Point(64, 50);
			this.labelPosition.Name = "labelPosition";
			this.labelPosition.Size = new System.Drawing.Size(216, 16);
			this.labelPosition.TabIndex = 6;
			// 
			// buttonEditPosition
			// 
			this.buttonEditPosition.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonEditPosition.Location = new System.Drawing.Point(296, 47);
			this.buttonEditPosition.Name = "buttonEditPosition";
			this.buttonEditPosition.Size = new System.Drawing.Size(56, 23);
			this.buttonEditPosition.TabIndex = 7;
			this.buttonEditPosition.Text = "Edit...";
			this.buttonEditPosition.Click += new System.EventHandler(this.buttonEditPosition_Click);
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 84);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(32, 16);
			this.label3.TabIndex = 8;
			this.label3.Text = "Axis:";
			// 
			// labelAxis
			// 
			this.labelAxis.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.labelAxis.Location = new System.Drawing.Point(64, 84);
			this.labelAxis.Name = "labelAxis";
			this.labelAxis.Size = new System.Drawing.Size(216, 16);
			this.labelAxis.TabIndex = 9;
			// 
			// buttonEditAxis
			// 
			this.buttonEditAxis.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonEditAxis.Location = new System.Drawing.Point(296, 81);
			this.buttonEditAxis.Name = "buttonEditAxis";
			this.buttonEditAxis.Size = new System.Drawing.Size(56, 23);
			this.buttonEditAxis.TabIndex = 10;
			this.buttonEditAxis.Text = "Edit...";
			this.buttonEditAxis.Click += new System.EventHandler(this.buttonEditAxis_Click);
			// 
			// checkBoxCapped
			// 
			this.checkBoxCapped.Location = new System.Drawing.Point(8, 118);
			this.checkBoxCapped.Name = "checkBoxCapped";
			this.checkBoxCapped.Size = new System.Drawing.Size(96, 24);
			this.checkBoxCapped.TabIndex = 11;
			this.checkBoxCapped.Text = "Ends Capped";
			// 
			// label4
			// 
			this.label4.Anchor = System.Windows.Forms.AnchorStyles.Top;
			this.label4.Location = new System.Drawing.Point(112, 122);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(48, 16);
			this.label4.TabIndex = 12;
			this.label4.Text = "Radius:";
			// 
			// label5
			// 
			this.label5.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.label5.Location = new System.Drawing.Point(232, 122);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(40, 16);
			this.label5.TabIndex = 13;
			this.label5.Text = "Height:";
			// 
			// numericUpDownRadius
			// 
			this.numericUpDownRadius.Anchor = System.Windows.Forms.AnchorStyles.Top;
			this.numericUpDownRadius.DecimalPlaces = 2;
			this.numericUpDownRadius.Location = new System.Drawing.Point(160, 120);
			this.numericUpDownRadius.Maximum = new System.Decimal(new int[] {
																				999999999,
																				0,
																				0,
																				0});
			this.numericUpDownRadius.Minimum = new System.Decimal(new int[] {
																				1215752191,
																				23,
																				0,
																				-2147483648});
			this.numericUpDownRadius.Name = "numericUpDownRadius";
			this.numericUpDownRadius.Size = new System.Drawing.Size(64, 20);
			this.numericUpDownRadius.TabIndex = 14;
			// 
			// numericUpDownHeight
			// 
			this.numericUpDownHeight.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.numericUpDownHeight.DecimalPlaces = 2;
			this.numericUpDownHeight.Location = new System.Drawing.Point(280, 120);
			this.numericUpDownHeight.Maximum = new System.Decimal(new int[] {
																				99999999,
																				0,
																				0,
																				0});
			this.numericUpDownHeight.Minimum = new System.Decimal(new int[] {
																				999999999,
																				0,
																				0,
																				-2147483648});
			this.numericUpDownHeight.Name = "numericUpDownHeight";
			this.numericUpDownHeight.Size = new System.Drawing.Size(64, 20);
			this.numericUpDownHeight.TabIndex = 15;
			// 
			// EditCylinderForm
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(362, 360);
			this.Controls.Add(this.numericUpDownHeight);
			this.Controls.Add(this.numericUpDownRadius);
			this.Controls.Add(this.label5);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.checkBoxCapped);
			this.Controls.Add(this.buttonEditAxis);
			this.Controls.Add(this.labelAxis);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.buttonEditPosition);
			this.Controls.Add(this.labelPosition);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.textBoxName);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.Controls.Add(this.materialEditorControl1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditCylinderForm";
			this.ShowInTaskbar = false;
			this.Text = "Edit Cylinder";
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownRadius)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownHeight)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			m_originalCylinder.Position = m_position;
			m_originalCylinder.Axis = m_axis;
			m_originalCylinder.Name = this.textBoxName.Text;
			m_originalCylinder.Radius = (float)this.numericUpDownRadius.Value;
			m_originalCylinder.Height = (float)this.numericUpDownHeight.Value;
			m_originalCylinder.Material = this.materialEditorControl1.Material;
			m_originalCylinder.Capped = this.checkBoxCapped.Checked;
		
		}

		#region IEditor Members

		/// <summary>
		/// Gets or sets the object this form edits
		/// </summary>
		public object EditableObject
		{
			get
			{
				return m_originalCylinder;
			}
			set
			{
				this.m_originalCylinder = value as Cylinder;
				this.m_position = (Vector3f)m_originalCylinder.Position.Clone();
				this.m_axis = (Vector3f)m_originalCylinder.Axis.Clone();
				this.materialEditorControl1.Material = m_originalCylinder.Material;

				UpdateView();
				
			}
		}

		
		#endregion

		/// <summary>
		/// Updates view with all variables.
		/// </summary>
		private void UpdateView() 
		{
			this.checkBoxCapped.Checked = m_originalCylinder.Capped;
			this.textBoxName.Text = m_originalCylinder.Name;
			this.numericUpDownHeight.Value = (Decimal)m_originalCylinder.Height;
			this.numericUpDownRadius.Value = (Decimal)m_originalCylinder.Radius;

			this.labelAxis.Text = this.m_axis.ToString();
			this.labelPosition.Text = this.m_position.ToString();
		}

		private void buttonEditPosition_Click(object sender, System.EventArgs e)
		{
			EditVectorForm f = new EditVectorForm();
			f.EditableObject = m_position;
			if (f.ShowDialog()==DialogResult.OK) 
			{
				m_position = f.EditableObject as Vector3f;
				this.labelPosition.Text = m_position.ToString();
			}
		}

		private void buttonEditAxis_Click(object sender, System.EventArgs e)
		{
			EditVectorForm f = new EditVectorForm();
			f.EditableObject = m_axis;
			if (f.ShowDialog()==DialogResult.OK) 
			{
				m_axis = f.EditableObject as Vector3f;
				this.labelAxis.Text = m_axis.ToString();
			}
		}
	}
}
