/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *		Implementation of editor for a Color4f object.
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - Added to VSS
 *		12/25/2004 - Ben Watson - Added XML comments
 * 
 *--*/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// A form for editing colors
	/// </summary>
	public class EditColorForm : System.Windows.Forms.Form, IEditor
	{
		#region UI elements
		private System.Windows.Forms.Label label1;
		private BenWatson.BRayTracer.Editors.ColorEditorControl colorEditorControl1;
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion

		/// <summary>
		/// Stores a reference to the original color object.
		/// </summary>
		private Color4f m_originalColor = null;

		/// <summary>
		/// Constructs an EditColorForm
		/// </summary>
		public EditColorForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.colorEditorControl1 = new BenWatson.BRayTracer.Editors.ColorEditorControl();
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 20);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(40, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Color:";
			// 
			// colorEditorControl1
			// 
			this.colorEditorControl1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.colorEditorControl1.Color = null;
			this.colorEditorControl1.Location = new System.Drawing.Point(56, 8);
			this.colorEditorControl1.Name = "colorEditorControl1";
			this.colorEditorControl1.Size = new System.Drawing.Size(240, 40);
			this.colorEditorControl1.TabIndex = 0;
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(146, 50);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 1;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(226, 50);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 2;
			this.buttonCancel.Text = "&Cancel";
			// 
			// EditColorForm
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(306, 80);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.Controls.Add(this.colorEditorControl1);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditColorForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Edit Color";
			this.ResumeLayout(false);

		}
		#endregion

		#region IEditor Members

		/// <summary>
		/// Gets or sets the object editable by this form.
		/// </summary>
		public object EditableObject
		{
			get
			{
				return this.colorEditorControl1.Color;
			}
			set
			{
				this.m_originalColor = (Color4f)value;
				this.colorEditorControl1.Color = value as Color4f;
			}
		}

		#endregion

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
            Color4f c = this.colorEditorControl1.Color;

			m_originalColor.Red = c.Red;
			m_originalColor.Blue = c.Blue;
			m_originalColor.Green = c.Green;
		}
	}
}
