/*++
 * Copyright 2004 Ben Watson. This code may be used for non-commercial purposes only. You must
 * credit the author.
 *
 * Module-Name:
 *     BRayTracer
 *
 * Author:
 *     Ben Watson (dev@benwatson.org) 12/20/2004
 *
 * Abstract:
 *     A form for editing a checkerboard plane
 *
 * Revision History:
 *		12/20/2004 - Ben Watson - Added to VSS
 *		12/21/2004 - Ben Watson - Added XML commments
 *
 *--*/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using BenWatson.BRayTracer;
using BenWatson.BRayTracer.Primitives;

namespace BenWatson.BRayTracer.Editors
{
	/// <summary>
	/// A form for editing checkerboard-patterned planes.
	/// </summary>
	/// <remarks>Currently, the plane must be facing directly up.</remarks>
	public class EditCheckerboardForm : System.Windows.Forms.Form, IEditor
	{
		#region UI elements
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private BenWatson.BRayTracer.Editors.MaterialEditorControl materialEditorControl1;
		private BenWatson.BRayTracer.Editors.MaterialEditorControl materialEditorControl2;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox textBoxName;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label labelPosition;
		private System.Windows.Forms.Button buttonEditPosition;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Button buttonEditNormal;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.NumericUpDown numericUpDownTileSize;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Label labelNormal;

		#endregion

		/// <summary>
		/// Position vector displayed
		/// </summary>
		private Vector3f m_position = null;
		/// <summary>
		/// Normal vector displayed
		/// </summary>
		private Vector3f m_normal = null;
		

		/// <summary>
		/// Reference to original checkerboard object so we can update it when we're done.
		/// </summary>
		private Checkerboard m_originalCheckerboard = null;

		/// <summary>
		/// Initializes a new checkerboard editor form
		/// </summary>
		public EditCheckerboardForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.materialEditorControl1 = new BenWatson.BRayTracer.Editors.MaterialEditorControl();
			this.materialEditorControl2 = new BenWatson.BRayTracer.Editors.MaterialEditorControl();
			this.label1 = new System.Windows.Forms.Label();
			this.textBoxName = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.labelPosition = new System.Windows.Forms.Label();
			this.buttonEditPosition = new System.Windows.Forms.Button();
			this.label3 = new System.Windows.Forms.Label();
			this.labelNormal = new System.Windows.Forms.Label();
			this.buttonEditNormal = new System.Windows.Forms.Button();
			this.label4 = new System.Windows.Forms.Label();
			this.numericUpDownTileSize = new System.Windows.Forms.NumericUpDown();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownTileSize)).BeginInit();
			this.SuspendLayout();
			// 
			// buttonOK
			// 
			this.buttonOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.Location = new System.Drawing.Point(452, 316);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 0;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(532, 316);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 1;
			this.buttonCancel.Text = "&Cancel";
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox1.Controls.Add(this.materialEditorControl1);
			this.groupBox1.Location = new System.Drawing.Point(8, 120);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(288, 192);
			this.groupBox1.TabIndex = 2;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Material 1";
			// 
			// groupBox2
			// 
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox2.Controls.Add(this.materialEditorControl2);
			this.groupBox2.Location = new System.Drawing.Point(312, 120);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(288, 192);
			this.groupBox2.TabIndex = 3;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Material 2";
			// 
			// materialEditorControl1
			// 
			this.materialEditorControl1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.materialEditorControl1.Location = new System.Drawing.Point(3, 16);
			this.materialEditorControl1.Material = null;
			this.materialEditorControl1.Name = "materialEditorControl1";
			this.materialEditorControl1.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.materialEditorControl1.Size = new System.Drawing.Size(282, 173);
			this.materialEditorControl1.TabIndex = 0;
			// 
			// materialEditorControl2
			// 
			this.materialEditorControl2.Dock = System.Windows.Forms.DockStyle.Fill;
			this.materialEditorControl2.Location = new System.Drawing.Point(3, 16);
			this.materialEditorControl2.Material = null;
			this.materialEditorControl2.Name = "materialEditorControl2";
			this.materialEditorControl2.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.materialEditorControl2.Size = new System.Drawing.Size(282, 173);
			this.materialEditorControl2.TabIndex = 0;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(40, 16);
			this.label1.TabIndex = 4;
			this.label1.Text = "Name:";
			// 
			// textBoxName
			// 
			this.textBoxName.Location = new System.Drawing.Point(64, 6);
			this.textBoxName.Name = "textBoxName";
			this.textBoxName.Size = new System.Drawing.Size(136, 20);
			this.textBoxName.TabIndex = 5;
			this.textBoxName.Text = "";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 48);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(48, 16);
			this.label2.TabIndex = 6;
			this.label2.Text = "Position: ";
			// 
			// labelPosition
			// 
			this.labelPosition.Location = new System.Drawing.Point(64, 48);
			this.labelPosition.Name = "labelPosition";
			this.labelPosition.Size = new System.Drawing.Size(168, 16);
			this.labelPosition.TabIndex = 7;
			// 
			// buttonEditPosition
			// 
			this.buttonEditPosition.Location = new System.Drawing.Point(240, 45);
			this.buttonEditPosition.Name = "buttonEditPosition";
			this.buttonEditPosition.Size = new System.Drawing.Size(56, 23);
			this.buttonEditPosition.TabIndex = 8;
			this.buttonEditPosition.Text = "Edit...";
			this.buttonEditPosition.Click += new System.EventHandler(this.buttonEditPosition_Click);
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 80);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(48, 16);
			this.label3.TabIndex = 9;
			this.label3.Text = "Normal:";
			// 
			// labelNormal
			// 
			this.labelNormal.Location = new System.Drawing.Point(64, 80);
			this.labelNormal.Name = "labelNormal";
			this.labelNormal.Size = new System.Drawing.Size(168, 16);
			this.labelNormal.TabIndex = 10;
			// 
			// buttonEditNormal
			// 
			this.buttonEditNormal.Enabled = false;
			this.buttonEditNormal.Location = new System.Drawing.Point(240, 77);
			this.buttonEditNormal.Name = "buttonEditNormal";
			this.buttonEditNormal.Size = new System.Drawing.Size(56, 23);
			this.buttonEditNormal.TabIndex = 11;
			this.buttonEditNormal.Text = "Edit...";
			this.buttonEditNormal.Click += new System.EventHandler(this.buttonEditNormal_Click);
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(320, 48);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(56, 16);
			this.label4.TabIndex = 12;
			this.label4.Text = "Tile Size:";
			// 
			// numericUpDownTileSize
			// 
			this.numericUpDownTileSize.DecimalPlaces = 2;
			this.numericUpDownTileSize.Location = new System.Drawing.Point(384, 46);
			this.numericUpDownTileSize.Maximum = new System.Decimal(new int[] {
																				  1410065407,
																				  2,
																				  0,
																				  0});
			this.numericUpDownTileSize.Minimum = new System.Decimal(new int[] {
																				  -727379969,
																				  232,
																				  0,
																				  -2147483648});
			this.numericUpDownTileSize.Name = "numericUpDownTileSize";
			this.numericUpDownTileSize.Size = new System.Drawing.Size(72, 20);
			this.numericUpDownTileSize.TabIndex = 13;
			// 
			// EditCheckerboardForm
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(608, 342);
			this.Controls.Add(this.numericUpDownTileSize);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.buttonEditNormal);
			this.Controls.Add(this.labelNormal);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.buttonEditPosition);
			this.Controls.Add(this.labelPosition);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.textBoxName);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "EditCheckerboardForm";
			this.ShowInTaskbar = false;
			this.Text = "Edit Checkerboard";
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownTileSize)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Event handler for position edit button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		/// <remarks>Uses the vector edit form.</remarks>
		private void buttonEditPosition_Click(object sender, System.EventArgs e)
		{
			EditVectorForm f = new EditVectorForm();
			f.EditableObject = m_position;
			if (f.ShowDialog()==DialogResult.OK) 
			{
				this.m_position = f.EditableObject as Vector3f;
				this.labelPosition.Text = m_position.ToString();
			}
		}

		/// <summary>
		/// Event handler for normal edit button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		/// <remarks>Currently disabled.</remarks>
		private void buttonEditNormal_Click(object sender, System.EventArgs e)
		{
			EditVectorForm f = new EditVectorForm();
			f.EditableObject = m_normal;
			if (f.ShowDialog()==DialogResult.OK) 
			{
				this.m_normal = f.EditableObject as Vector3f;
				this.labelNormal.Text = m_normal.ToString();
			}
		}

		/// <summary>
		/// Event handler for OK button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			m_originalCheckerboard.Material = this.materialEditorControl1.Material;
			m_originalCheckerboard.TileMaterial = this.materialEditorControl2.Material;
			m_originalCheckerboard.TileSize = (float)this.numericUpDownTileSize.Value;
			m_originalCheckerboard.Position = m_position;
			m_originalCheckerboard.Normal = m_normal;
			m_originalCheckerboard.Name = this.textBoxName.Text;
		}

		#region IEditor Members

		/// <summary>
		/// Gets or sets the object editable by this form.
		/// </summary>
		public object EditableObject
		{
			get
			{
				return m_originalCheckerboard;
			}
			set
			{
				m_originalCheckerboard = (Checkerboard)value;
				this.m_normal = (Vector3f)m_originalCheckerboard.Normal.Clone();
				this.m_position = (Vector3f)m_originalCheckerboard.Position.Clone();

				this.materialEditorControl1.Material = m_originalCheckerboard.Material;
				this.materialEditorControl2.Material = m_originalCheckerboard.TileMaterial;

				this.numericUpDownTileSize.Value = (Decimal)m_originalCheckerboard.TileSize;

				this.textBoxName.Text = this.m_originalCheckerboard.Name;
				this.labelPosition.Text = m_position.ToString();
				this.labelNormal.Text = m_normal.ToString();
			}
		}

		#endregion
	}
}
